<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Kubwa Events</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.7 -->
    <?php include('./layouts/styles.php') ?>
</head>

<body class="hold-transition login-page">
    <div class="container">
        
        <div class="row" style="margin-top: 20px;">
            <div class="col-md-3"></div>
            <div class="col-md-6">
                <div class="login-logo">
                    <!-- <a href=""><img src="./public/backend/assets/images/lapariah.jpg" alt="LOGO" style="width: 100%;height: 117px;"></a> -->
                    <!-- <img src="./public/event_banner.jpeg" alt="LOGO" style="width: 100%;height:400px;object-fit: contain;" class="img-responsive"><br>
                    <img src="./public/vendor_banner.jpeg" alt="LOGO" style="width: 100%;height:400px;object-fit: contain;" class="img-responsive"><br> -->
                </div>
                <!-- /.login-logo -->
                <div class="login-box-body">
                    <div class="alert alert-danger alert-dismissible" style="display: none;" id="error-msg-div">
                        <button class="close" data-dismiss="alert">&times;</button>
                        <span id="error-msg"></span>
                    </div>
                    <h3 class="login-box-msg"><b><u>Kubwa Festival Registration Form</u></b></h3>            
                    <form id="reg-form" method="POST" enctype="multipart/form-data">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group has-feedback">
                                    <input type="text" class="form-control" id="fullname" name="fullname" placeholder="Enter Full Name" required>
                                    <span class="glyphicon glyphicon-user form-control-feedback"></span>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group has-feedback">
                                    <input type="email" class="form-control" id="email" name="email" placeholder="Enter Email" required>
                                    <span class="glyphicon glyphicon-envelope form-control-feedback"></span>
                                </div>
                            </div>
                            
                        </div>
                       
                        <div class="form-group has-feedback">
                            <input type="number" class="form-control" id="phone_no" name="phone_no" placeholder="Enter Phone Number" required>
                            <span class="glyphicon glyphicon-phone form-control-feedback"></span>
                        </div>
                        <div class="form-group has-feedback">
                            <label>Are you a Vendor? <span class="fa fa-bank"></span></label>
                            <select name="is_vendor" id="is_vendor" class="form-control" required>
                                <option value="">-- Select --</option>
                                <option value="yes">Yes</option>
                                <option value="no">No</option>
                            </select>
                        </div>
                        <div class="form-group has-feedback" style="visibility: hidden;position: absolute;" id="business_name_div">
                            <input type="text" class="form-control" id="business_name" name="business_name" placeholder="Enter Business Name">
                            <span class="glyphicon glyphicon-brief-case form-control-feedback"></span>
                        </div>
                        <div class="form-group has-feedback">
                            <label>Payment Type <span class="glyphicon glyphicon-credit-card"></span></label>
                           <input type="text" name="payment_type" class="form-control" id="payment_type" required readonly>
                        </div>
                        <div class="form-group has-feedback">
                            <label>Payment Amount (&#8358;)</label>
                            <input type="number" class="form-control" id="reg_fee" name="reg_fee" required readonly>
                            <span class="glyphicon glyphicon-credit-card form-control-feedback"></span>
                        </div>
                        <div class="form-group has-feedback">
                            <label>Payment Proof</label>
                            <input type="file" class="form-control" accept="image/*" id="picture" name="picture" required>
                            <span class="glyphicon glyphicon-picture form-control-feedback"></span>
                        </div>
                        <div class="form-group has-feedback">
                            <label>Make Payment to the Bank Details Below:</label>
                            <ul>
                                <li><h4><b>Bank Name:</b></h4> <b>Moniepoint MFB</b></li>
                                <li><h4><b>Account Name:</b></h4><b>HelpquartersNG owned by OLUWAYEMISI ABEGUNDE </b></li>
                                <li><h4><b>Account Number:</b></h4><b> 6435374492</b></li>
                            </ul>
                        </div>
                        <div class="row">
                            <!-- /.col -->
                            <div class="col-xs-12">
                                <button type="submit" id="submit-btn" class="btn btn-success btn-block btn-flat">Submit</button>
                            </div>
                            <!-- /.col -->
                        </div>
                    </form>
                </div>
                <!-- /.login-box-body -->
            </div>
        </div>
    </div>
    <!-- /.login-box -->

    <?php include('./layouts/scripts.php'); ?>
    <script>

        (function ($) {

            $(document).ready(function(){
                $.ajax({
                    type:"GET",
                    url:"./__factory/web.php?route=getRegData",
                    data:{},
                    dataType:"json",
                    cache:false,
                    success:function(res){
                        console.log('onloadRes=>', res);
                        // check res
                        if(res.status ==  200){
                            $("#payment_type").empty();
                            let config  = res.data.config;

                            if(config.payment_type == 'early_bird'){
                                $("#payment_type").val('Early Bird');
                                $("#reg_fee").val(config.early_bird_fee);
                            }else{
                                $("#payment_type").val('Ticket');
                                $("#reg_fee").val(config.reg_fee);
                            }
                        }
                    },
                    error:function(err){
                        console.log('Error fetch reg fee', err);
                    }
                });
            });

            $('body').on('change', '#is_vendor', function(){
                let is_vendor =  $("#is_vendor").val();

                if(is_vendor.length < 1){
                    $("#reg_fee").val('');
                    return;
                }

                if(is_vendor == 'no'){

                    $("#business_name_div").css({visibility: 'hidden', position:'absolute'});
                }else{

                    $("#business_name_div").css({visibility: 'visible', position:'relative'});
                }
            });

            $('body').on('submit', '#reg-form', function(e){
                e.preventDefault();
            
                // check network connection
                let connection_status = window.navigator.onLine;
                if(connection_status == false){
                    toastr.error('Please check your internet connection.');
                    return;
                }

                // collect data for registration
                var formValues = new FormData(this);

                // get data to process registration
                $("#submit-btn").attr('disabled', true).html(`Processing.... <i class='fa fa-spinner fa-spin'><i/>`);

                $.ajax({
                    type: "POST",
                    url: "./__factory/web.php?route=registerUser",
                    data: formValues,
                    contentType: false,
                    processData: false,
                    cache: false,
                    dataType: "json",
                    success:function(res){
                        console.log('res=>', res);

                        // check res
                        if(res.status ==  201){
                            toastr.success(res.message);
                            setTimeout(function(){
                                window.location.reload();
                            }, 5000);
                        }else{
                            toastr.error(res.message);
                            $('#submit-btn').attr('disabled', false).html('Submit');
                        }
                    },
                    error:function(err){
                        $('#submit-btn').attr('disabled', false).html('Submit');
                        console.log("Error Fetching Reg Data==>", err);
                    }
                })
            });
        })(jQuery);
    </script>
</body>
</html>